void main() {
    final int maxKand = 1000;
    int grenze;
    IO.println("Primzahlensuche mit dem Sieb des Eratosthenes\n");
    while (true) {
        // Aufgabe holen
        do {
            do {
                grenze = Simput.gint("Suchen bis (erlaubt: 2 bis " + maxKand + ", Beenden mit 0): ");
            } while (Simput.checkError());
            if (grenze == 0) {
                IO.println("\nViele Dank fuer den Einsatz dieser Software!\n");
                System.exit(0); //Beendet das Programm
            } else if (grenze < 2 || grenze > maxKand) {
                IO.println("Ungültiger Wert!\n");
            }
        } while (grenze < 2 || grenze > maxKand);

        // Kandidaten-Array erzeugen und vorbereiten
        boolean[] prim;
        int maxBasis = (int) Math.sqrt(grenze);
        prim = new boolean[grenze + 1];
        for (int i = 2; i <= grenze; i++)
            prim[i] = true;

        // Sieb des Eratosthenes
        for (int basis = 2; basis <= maxBasis; basis++) {
            if (!prim[basis])
                continue;
            for (int i = 2; i * basis <= grenze; i++)
                prim[i * basis] = false;
        }

        // Ergebnis ausgeben (10 Primzahlen pro Zeile)
        IO.println("\nPrimzahlen bis " + grenze + ":\n");
        int j = 0;
        for (int i = 2; i <= grenze; i++) {
            if (prim[i]) {
                j++;
                if (j == 1)
                    if (i == 2)
                        System.out.printf("%4d", i);
                    else
                        System.out.printf(",\n%4d", i);
                else
                    System.out.printf(",%4d", i);
                if (j == 10)
                    j = 0;
            }
        }
        IO.println("\n");
    }
}